 ; Ŀ
 ;   CW - rewidth all clouds in the current space.                         
 ;   Also contains Wc: set the widths back to 0.                           
 ;   Copyright 1991, 2006, 2010 by Rocket Software Ltd.                    
 ;   Life is like Lisp - everything is everything.                         
 ; 

 ; Ŀ
 ;   Clop - find all cloud polylines in a drawing.                         
 ;   Takes no arguments, returns an ss or nil.                             
 ;   Any polyline with more than three segments and a bulge factor on      
 ;   each one is assumed to be a cloud.                                    
 ; 
 (DEFUN CLOP (/ ss pos rad so s1 stilok vrtx pa)
  (setq rad (/ (getvar "viewsize") 99))
 ; Ŀ
 ;   Call Wasp (from the file Misps.lsp) to see which space we're in.      
 ;   Returns: 1 - Model space.                                             
 ;            2 - Paper space.                                             
 ;            3 - A Viewport in Paper Space.                               
 ; 
  (if (= 2 (wasp))
      (setq ss (ssget "X" '((0 . "POLYLINE") (67 . 1))))
      (setq ss (ssget "X" '((0 . "POLYLINE") (67 . 0)))))
  (setq pos 0)
  (if ss
      (while (setq so (ssname ss pos))
             (setq s1 (entnext so))
             (setq stilok T)                    ; bulge ok flag
             (setq num 0)
             (while (and stilok
                         (/= "SEQEND" (cdr (assoc 0 (setq vrtx (entget
                                                 (setq s1 (entnext s1))))))))
                    (if (= 0 (cdr (assoc 42 (entget s1))))
                        (setq stilok ())
                        (progn
                             (setq num (1+ num))
                             (setq pa (cdr (assoc 10 vrtx)))
                             (grdraw (polar pa (/ pi 4) rad)
                                     (polar pa (* 1.25 pi) rad) 110)
                             (grdraw (polar pa (* pi 0.75) rad)
                                     (polar pa (* pi 1.75) rad) 220))))
             (if (and stilok (> num 2))
                 (setq pos (1+ pos))
                 (ssdel so ss))))
 (if (not (zerop (sslength ss))) ss ()))
 ; Ŀ
 ;   Clop end.                                                             
 ; 

 ; Ŀ
 ;   Layp - see if a layer is off, locked, or frozen.                      
 ;   Takes one argument, a layer name.                                     
 ;   Returns a list of conditions or nil                                   
 ; 
 (DEFUN LAYP (lanam / llist sev col stalst)
  (setq llist (tblsearch "layer" lanam))
  (setq sev (cdr (assoc 70 llist)))
  (setq col (cdr (assoc 62 llist)))
  (if (= (logand sev 1) 1) (setq stalst (list "frozen")))
  (if (= (logand sev 4) 4) (setq stalst (cons "locked" stalst)))
  (if (minusp col) (setq stalst (cons "off" stalst)))
 stalst)
 ; Ŀ
 ;   Layp end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Cw - rewidth an ss of polylines.                           
 ;   Takes one argument, a width.                                          
 ;   Calls Clop, returns nothing.                                          
 ; 
 (DEFUN CW (pwid / ss num enam entt)
  (setvar "cmdecho" 0)
  (command "undo" "be")
 ; Ŀ
 ;   Make a local error handler.                                           
 ; 
  (defun *error* (shk)
   (command "undo" "end")
   (if shk (write-line shk))
  (princ))
 ; Ŀ
 ;   Get an ss of cloud polylines.                                         
 ; 
  (setq ss (clop))
(print ss)
 ; Ŀ
 ;   Rewidth any which are on accessible layers.                           
 ; 
  (setq num 0)
  (while (and ss (setq enam (ssname ss num)))
         (setq num (1+ num))
         (setq entt (entget enam))
         (if (null (layp (cdr (assoc 8 entt))))
             (command "pedit" enam "w" pwid "")))
 ; Ŀ
 ;   Clean up and end.                                                     
 ; 
  (*error* ())
 (princ))
 ; Ŀ
 ;   Subroutine Cw end.                                                    
 ; 

 ; Ŀ
 ;   Wc - set widths back to 0.                                            
 ; 
 (DEFUN C:WC ()
  (cw 0)
 (princ))

 ; Ŀ
 ;   Cw.                                                                   
 ; 
 (DEFUN C:CW ()
 ; Ŀ
 ;   Load Misps.lsp, which contains the ps/ms scaling subroutines.         
 ; 
  (if (null misps)
      (if (null (load "misps" ()))
          (prompt "\n** The File Misps.lsp Is Not Available. **\n")))
  (cw (* 0.75 (misps)))
 (princ))